<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package dsartndesign
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Dosis:wght@300;400;500;600;700&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.2.0/css/all.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"/>
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
        <link href="<?php echo get_template_directory_uri(); ?>/assets/css/style.css" rel="stylesheet" type="text/css"/>
        <?php wp_head(); ?>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
        <script src="<?php echo get_template_directory_uri(); ?>/assets/js/custom.js" type="text/javascript"></script>
    </head>
    <body <?php body_class(); ?>>
        <div id="top-bar">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-md-6 col-12">
                     <?php
                            wp_nav_menu(array(
                                'theme_location' => 'top-menu',
                                'container' => false,
                                'menu_class' => '',
                                'fallback_cb' => '__return_false',
                                'items_wrap' => '<ul id="%1$s" class="nav top-nav %2$s">%3$s</ul>',
                                'depth' => 2,
                                'walker' => new bootstrap_5_wp_nav_menu_walker()
                            ));
                            ?>
                    </div>
                    <div class="col-lg-6 col-md-6 col-12">
                        <ul class="nav social-nav">  
                            <li class="nav-item"> 
                                <a href="<?php echo of_get_option('fb_link') ?>" class="nav-link">
                                    <i class="fab fa-twitter"></i>
                                </a>
                            </li>
                            <li class="nav-item"> 
                                <a href="<?php echo of_get_option('tw_link') ?>" class="nav-link">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                            </li>
                            <li class="nav-item"> 
                                <a href="<?php echo of_get_option('pin_link') ?>" class="nav-link">
                                    <i class="fab fa-pinterest-p"></i>
                                </a>
                            </li>
                            <li class="nav-item"> 
                                <a href="<?php echo of_get_option('ins_link') ?>" class="nav-link">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            </li>
                            <li class="nav-item"> 
                                <a href="<?php echo of_get_option('fb_link') ?>" class="nav-link">
                                    <i class="fab fa-youtube"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <header id="header-content">
            <nav class="navbar navbar-expand-lg navbar-light">
                <div class="container">
                    <ul class="mobile-nav nav">
                        <li class="nav-item">
                            <?php
                            if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {

                                $count = WC()->cart->cart_contents_count;
                                ?><a class="cart-contents" href="<?php echo WC()->cart->get_cart_url(); ?>" title="<?php _e('View your shopping cart'); ?>"><?php
                                if ($count > 0) {
                                    ?>
                                        <button type="button" class="btn btn-badg position-relative">
                                            <i class="fas fa-shopping-bag"></i>
                                            <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                                <?php echo esc_html($count); ?>
                                                <span class="visually-hidden">unread messages</span>
                                            </span>
                                        </button>
                                        <?php
                                    }
                                    ?></a>
                            <?php } ?>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link sear">
                                <i class="fas fa-search"></i>
                            </a>
                        </li>
                    </ul>
                    <div class="navbar-brand">
                        <?php
                        the_custom_logo();
                        ?>
                    </div>
                    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#main-nav-expand" aria-controls="main-nav-expand" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="fal fa-bars"></i></span>
                    </button>
                    <div class="offcanvas offcanvas-end" id="main-nav-expand">
                        <div class="offcanvas-header">
                            <div class="navbar-brand">
                                <?php
                                the_custom_logo();
                                ?>
                            </div>
                            <button type="button" class="btn btn-clo text-reset" data-bs-dismiss="offcanvas" aria-label="Close"><i class="fas fa-times"></i></button>
                        </div>
                        <div class="offcanvas-body">
                            <?php
                            wp_nav_menu(array(
                                'theme_location' => 'menu-1',
                                'container' => false,
                                'menu_class' => '',
                                'fallback_cb' => '__return_false',
                                'items_wrap' => '<ul id="%1$s" class="navbar-nav main mx-auto %2$s">%3$s</ul>',
                                'depth' => 2,
                                'walker' => new bootstrap_5_wp_nav_menu_walker()
                            ));
                            ?>
                            <ul class="navbar-nav main mx-auto">
                                <li class="nav-item hide-on-mobile">
                                    <?php
                                    if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {

                                        $count = WC()->cart->cart_contents_count;
                                        ?><a class="cart-contents" href="<?php echo WC()->cart->get_cart_url(); ?>" title="<?php _e('View your shopping cart'); ?>"><?php
                                        ?>
                                            <button type="button" class="btn btn-badg position-relative">
                                                <i class="fas fa-shopping-bag"></i>
                                                <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                                    <?php echo esc_html($count); ?>
                                                    <span class="visually-hidden">unread messages</span>
                                                </span>
                                            </button>
                                            <?php
                                            ?></a>
                                        <?php } ?>

                                </li>
                                <li class="nav-item hide-on-mobile">
                                    <a href="#" class="nav-link sear">
                                        <i class="fas fa-search"></i>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#" class="nav-link btn btn-blog hide-on-mobile">
                                        <i class="fas fa-envelope"></i>
                                    </a>
                                </li>
                            </ul>
                            <div class="mobile-special-menu ">
<?php
wp_nav_menu(array(
    'theme_location' => 'menu-2',
    'container' => false,
    'menu_class' => '',
    'fallback_cb' => '__return_false',
    'items_wrap' => '<ul id="%1$s" class="nav mobile-menu flex-column %2$s">%3$s</ul>',
    'depth' => 2,
    'walker' => new bootstrap_5_wp_nav_menu_walker()
));
?>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </header>
  <div id="search">
            <div class="container">
                <button type="button" class="close btn"><i class="fal fa-times"></i></button>
                <div class="input-group">
                     <?php echo get_sidebar();?>
                </div>
            </div>
        </div>