<?php
/**
 * The template file
 * Template Name: Home Page
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package dsartndesign
 */
get_header();
?>

<?php
while (have_posts()) :
    the_post();
    ?>
    <div id="banner-area">
        <div id="carouselExampleControls" class="carousel slide" data-bs-ride="carousel">

            <div class="carousel-inner">
                <?php
                $banner_slider = get_posts(array('post_type' => 'site_banners', 'posts_per_page' => 10, 'order' => 'ASC'));
                $count = 0;
                $i = 1;
                foreach ($banner_slider as $banner_slider):
                    $class = "";
                    if ($i == 1) {
                        $class = "active";
                    }
                    ?>
                    <div class="carousel-item <?php echo $class; ?>">
                        <img src="<?= wp_get_attachment_url(get_post_thumbnail_id($banner_slider->ID)) ?>" alt="<?= get_the_title($banner_slider->ID) ?>" class="d-block w-100 ">
                    </div>
                    <?php $count++; ?>
                    <?php $i++; ?>
                    <?php
                endforeach;
                ?>
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev">
                <span class="carousel-control-prev" aria-hidden="true"><i class="fas fa-angle-left"></i></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next">
                <span class="carousel-control-next" aria-hidden="true"><i class="fas fa-angle-right"></i></span>
                <span class="visually-hidden">Next</span>
            </button>
        </div>

    </div>
    <main id="main-content">
        <section class="sec-1"> 
            <div class="container">
                <h1>INFORMATION</h1>
                <div class="card-sec">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-12">
                            <div class="card main-card">
                                <div class="overlay"></div>
                                <div class="img-box">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/cup1.jpg" alt="" class="img-fluid"/>
                                </div>
                                <div class="card-body">
                                    <div class="date">
                                        <p>PRE DESIGNED CUPS</p>
                                    </div>
                                    <a href="#" class="btn btn-see">
                                        SEE IT NOW <i class="fal fa-angle-double-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-12">
                            <div class="card main-card">
                                <div class="overlay"></div>
                                <div class="img-box">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/cup2.jpg" alt="" class="img-fluid"/>
                                </div>
                                <div class="card-body">
                                    <div class="date">
                                        <p>CUSTOMIZED CUSHIONS</p>
                                    </div>
                                    <a href="#" class="btn btn-see">
                                        SEE IT NOW <i class="fal fa-angle-double-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-12">
                            <div class="card main-card">
                                <div class="overlay"></div>
                                <div class="img-box">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/cup3.jpg" alt="" class="img-fluid"/>
                                </div>
                                <div class="card-body">
                                    <div class="date">
                                        <p>CUSTOMIZED CUSHIONS</p>
                                    </div>
                                    <a href="#" class="btn btn-see">
                                        SEE IT NOW <i class="fal fa-angle-double-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="sec-2">
            <div class="container">
                <h1>NEW ARRIVAL</h1>
                <div class="product-area">
                    <div class="owl-carousel owl-theme">
                        <?php
                        $creds = get_posts(array(
                            'post_type' => 'product',
                            'post_status' => 'publish',
                            'numberposts' => 3,
                            'order' => 'desc',
                        ));
                        $xx = 1;
                        foreach ($creds as $cred):
                            $image = wp_get_attachment_image_src(get_post_thumbnail_id($cred->ID), 'single-post-thumbnail');
                            $product = new WC_product($cred->ID);
                            ?>
                            <div class="item">
                                <div class="card product-card">
                                    <a href="<?= get_permalink($cred->ID) ?>" >  <img src="<?= $image[0] ?>" alt="<?= get_the_title($cred->ID) ?>" class="img-fluid"></a>
                                    <div class="card-body">
                                        <div class="category">
                                            <p><?= get_the_excerpt($cred->ID) ?></p>
                                        </div>
                                        <div class="product-title">
                                            <h4><h4><?= get_the_title($cred->ID) ?></h4></h4>
                                        </div>
                                        <div class="price">
                                            <p><?php $price = get_post_meta($cred->ID, '_price', true); ?><?php echo wc_price($price); ?></p>
                                        </div>
                                        <a href="<?= get_permalink($cred->ID) ?>" class="btn btn-product">
                                            Add to cart <i class="fal fa-angle-double-right"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php
                            $xx++;
                        endforeach;
                        ?>

                    </div>
                </div>
            </div>
        </section>
        <section class="sec-4">
            <div class="container">
                <div class="content-area">
                    <div class="stack-box-width">
                        <ul class="stack-cards js-stack-cards" style="padding-bottom: 40px;">
                            <?php
                            $prod_categories = get_terms('product_cat', array(
                                'orderby' => 'name',
                                'order' => 'ASC',
                                'hide_empty' => false, // 1 for yes, 0 for no
                                'parent' => 0 // 1 for show child categories, 0 for show only parent category
                            ));
                            foreach ($prod_categories as $prod_cat) :
                                $cat_thumb_id = get_woocommerce_term_meta($prod_cat->term_id, 'thumbnail_id', true);
                                $cat_thumb_url = wp_get_attachment_thumb_url($cat_thumb_id);
                                $term_link = get_term_link($prod_cat, 'product_cat');
                                ?>
                                <li class="stack-cards-item stack-cards-item stack-1" style="transform: translateY(0px);">
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6 align-self-center">
                                            <div class="con-box">
                                                <h3><?php echo $prod_cat->name; ?></h3>
                                                <p><?php echo $prod_cat->description; ?></p>
                                                <a href="<?php echo $term_link; ?>" class="btn btn-view">
                                                    View More
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-sm-6 col-md-6 green-bg align-self-center" style="background-color:#769e51 !important">
                                            <img src="<?php echo $cat_thumb_url; ?>" alt="<?php echo $prod_cat->name; ?>" class="img-fluid d-block mx-auto">
                                        </div>
                                    </div>
                                </li>
                                <?php
                            endforeach;
                            wp_reset_query();
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <section class="sec-3">
            <div class="container">
                <div class="overlay"></div>
                <div class="text-area">
                    <div class="row">
                        <div class="col-lg-2">

                        </div>
                        <div class="col-lg-6 col-md-6 col-12">
                            <h4>CUSTOM CUPS / CUSTOM SHIRTS / CUSTOM CUSIONS</h4>
                            <h1>
                                DS ART N DESIGN COLLECTION

                            </h1>
                            <p>Buy online custom designed cups, Shirts, Cushions, Key chains or order your own designs</p>
                            <a href="#" class="btn btn-main">
                                Order Now
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section> 
        <section class="sec-5">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-4 col-12">
                        <div class="card feature-card">
                            <div class="icon">
                                <i class="fas fa-globe"></i>
                            </div>
                            <div class="card-body">
                                <h4>SHIPPING COUNTRYWIDE</h4>
                                <p>Guaranteed Delivery In 4 Days</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-12">
                        <div class="card feature-card">
                            <div class="icon">
                                <i class="fas fa-dollar-sign"></i>
                            </div>
                            <div class="card-body">
                                <h4>MONEY BACK GUARANTEE</h4>
                                <p>Send Within 5 Days</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-12">
                        <div class="card feature-card">
                            <div class="icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="card-body">
                                <h4>24/7 CUSTOMER SERVICE</h4>
                                <p>Call Us 24/7 At 0322-4274178</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="sec-6">
            <div class="container">
                <div class="overlay"></div>
                <div class="newsletter-box">
                    <h1>Newslettter</h1>
                    <p>Please feel free to inquire about the rental and installation of the aquarium .</p>
                    <div class="form-box">
                        <?php echo dynamic_sidebar('sidebar2');?>
                       
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php
endwhile; // End of the loop.
?>


<?php
get_footer();
?>


